package edu.unl.consystlab.sudoku;

public interface Griddable
{
	// set it up
	public void clear();
	public void clear(int row, int col);
	public void lock(int row, int col, byte val);
	
	// help the solver
	public int getEntropy(int row, int col);
	public boolean isUsed(int row, int col, byte val);
	public boolean isOk(int row, int col);
	
	// standard getters/setters
	public void setValue(int row, int col, byte val);
	public void setState(int row, int col, byte state);
	public byte getValue(int row, int col);
	public byte getState(int row, int col);
	public int getProgressPct();
	
	// fixate fields entered by user
	public void lock();
	public void lockToggle();
}
